/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.base;

import filenet.vw.api.VWQueueDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.property.base.VWConfigOperationTableModel;
import filenet.vw.toolkit.admin.property.base.VWConfigParameterTableModel;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.table.VWTableCellEditor;
import filenet.vw.toolkit.utils.table.VWTableCellRenderer;
import filenet.vw.toolkit.utils.uicontrols.border.IVWToolbarBorderActionListener;
import filenet.vw.toolkit.utils.uicontrols.border.VWTitledBorder;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderActionEvent;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderClientActionEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.DefaultCellEditor;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;

public class VWConfigOperationPane
extends JPanel
implements TableModelListener,
ListSelectionListener,
DocumentListener,
IVWToolbarBorderActionListener {
    private VWToolbarBorder m_operationsToolBar = null;
    private VWTable m_operationTable = null;
    private JTextArea m_descriptionTextArea = null;
    private VWToolbarBorder m_parametersToolBar = null;
    private VWTable m_parameterTable = null;
    private VWQueueDefinition m_queueDefinition = null;
    private JDialog m_parent = null;
    private VWConfigOperationTableModel m_operationTableModel = null;
    private VWConfigParameterTableModel m_parameterTableModel = null;

    public VWConfigOperationPane(VWQueueDefinition queueDef, JDialog parent) {
        this.m_queueDefinition = queueDef;
        this.m_parent = parent;
        this.createControls();
        this.updateTableSelection(this.m_operationTable, 0);
    }

    public boolean isModified() {
        return this.m_operationTableModel.isModified() || this.m_parameterTableModel.isModified();
    }

    public void stopEditing() {
        if (this.m_operationTable != null) {
            this.m_operationTable.stopEditing();
        }
        if (this.m_parameterTable != null) {
            this.m_parameterTable.stopEditing();
        }
    }

    public void tableChanged(TableModelEvent event) {
        switch (event.getType()) {
            case -1: 
            case 1: {
                int nRow = event.getLastRow();
                if (nRow < 0) {
                    nRow = 0;
                }
                if (event.getSource() == this.m_operationTable.getModel()) {
                    this.updateTableSelection(this.m_operationTable, nRow);
                    break;
                }
                if (event.getSource() != this.m_parameterTable.getModel()) break;
                this.updateTableSelection(this.m_parameterTable, nRow);
            }
        }
        this.m_parameterTable.setFocusable(this.m_parameterTable.getRowCount() != 0);
    }

    public void valueChanged(ListSelectionEvent event) {
        try {
            if (event.getValueIsAdjusting()) {
                return;
            }
            if (event.getSource() == this.m_operationTable.getSelectionModel()) {
                this.onSelectedOperation();
            } else if (event.getSource() == this.m_parameterTable.getSelectionModel()) {
                this.onSelectedParameter();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void changedUpdate(DocumentEvent event) {
    }

    public void insertUpdate(DocumentEvent event) {
        try {
            if (event.getDocument() == this.m_descriptionTextArea.getDocument()) {
                this.onUpdateDescription();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void removeUpdate(DocumentEvent event) {
        try {
            if (event.getDocument() == this.m_descriptionTextArea.getDocument()) {
                this.onUpdateDescription();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void toolbarBorderActionPerformed(VWToolbarBorderActionEvent event) {
        try {
            this.m_operationTable.stopEditing();
            this.m_parameterTable.stopEditing();
            if (event.getSource() == this.m_operationsToolBar) {
                int nRowIndex = this.m_operationTable.getSelectedRow();
                if (nRowIndex == -1) {
                    return;
                }
                switch (event.getID()) {
                    case 64: {
                        this.m_operationTableModel.copyItem(nRowIndex);
                        this.m_operationTable.setRowSelectionInterval(this.m_operationTableModel.getRowCount() - 1, this.m_operationTableModel.getRowCount() - 1);
                        break;
                    }
                    case 0x10000000: {
                        this.m_operationTableModel.deleteItem(nRowIndex);
                    }
                }
            } else if (event.getSource() == this.m_parametersToolBar) {
                int nRowIndex = this.m_parameterTable.getSelectedRow();
                if (nRowIndex == -1) {
                    return;
                }
                switch (event.getID()) {
                    case 0x10000000: {
                        this.m_parameterTableModel.deleteItem(nRowIndex);
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void createControls() {
        GridBagConstraints gbCons = null;
        try {
            this.setBorder(new EmptyBorder(5, 5, 5, 5));
            this.setLayout(new GridBagLayout());
            gbCons = new GridBagConstraints();
            gbCons.anchor = 23;
            gbCons.fill = 1;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.weightx = 0.2;
            gbCons.weighty = 0.75;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(2, 2, 2, 2);
            this.add((Component)this.createOperationsPanel(), gbCons);
            ++gbCons.gridy;
            gbCons.weightx = 0.2;
            gbCons.weighty = 0.25;
            this.add((Component)this.createDescriptionPanel(), gbCons);
            ++gbCons.gridx;
            gbCons.gridy = 0;
            gbCons.weightx = 0.8;
            gbCons.weighty = 1.0;
            gbCons.gridheight = 2;
            this.add((Component)this.createParametersPanel(), gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void releaseResources() {
        if (this.m_operationsToolBar != null) {
            this.m_operationsToolBar.releaseResources();
            this.m_operationsToolBar = null;
        }
        if (this.m_parametersToolBar != null) {
            this.m_parametersToolBar.releaseResources();
            this.m_parametersToolBar = null;
        }
        if (this.m_operationTable != null) {
            this.m_operationTable.removeAll();
            this.m_operationTable = null;
        }
        if (this.m_descriptionTextArea != null) {
            this.m_descriptionTextArea.removeAll();
            this.m_descriptionTextArea = null;
        }
        if (this.m_parameterTable != null) {
            this.m_parameterTable.removeAll();
            this.m_parameterTable = null;
        }
        this.m_queueDefinition = null;
        this.m_parent = null;
        if (this.m_operationTableModel != null) {
            this.m_operationTableModel.releaseResources();
            this.m_operationTableModel = null;
        }
        if (this.m_parameterTableModel != null) {
            this.m_parameterTableModel.releaseResources();
            this.m_parameterTableModel = null;
        }
        this.removeAll();
    }

    private JPanel createOperationsPanel() {
        JPanel panel = null;
        try {
            this.m_operationsToolBar = new VWToolbarBorder(VWResource.Operations, 0x10000040);
            this.m_operationsToolBar.addToolbarBorderActionNotifier(this);
            panel = this.m_operationsToolBar.getClientPanel();
            panel.setLayout(new BorderLayout());
            this.m_operationTableModel = new VWConfigOperationTableModel(this.m_queueDefinition, this.m_parent);
            this.m_operationTableModel.addTableModelListener(this);
            this.m_operationTable = new VWTable(this.m_operationTableModel);
            this.m_operationTable.setRowSelectionAllowed(true);
            this.m_operationTable.getSelectionModel().addListSelectionListener(this);
            this.m_operationTable.getSelectionModel().setSelectionMode(0);
            this.m_operationTable.setDefaultRenderer(String.class, new VWTableCellRenderer());
            this.m_operationTable.setDefaultEditor(String.class, new VWTableCellEditor(new JTextField()));
            panel.add((Component)new JScrollPane(this.m_operationTable), "Center");
            VWAccessibilityHelper.setAccessibility(this.m_operationTable, this, VWResource.OperationsTable, VWResource.OperationsTable);
            JLabel label = new JLabel(VWResource.OperationsTable);
            VWAccessibilityHelper.setAccessibility(label, this, VWResource.OperationsTable, VWResource.OperationsTable);
            VWAccessibilityHelper.setLabelFor(label, this.m_operationTable);
            return this.m_operationsToolBar;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel createDescriptionPanel() {
        JPanel panel = null;
        try {
            panel = new JPanel(new BorderLayout());
            panel.setBorder(new VWTitledBorder(VWResource.OperationDescription));
            this.m_descriptionTextArea = new JTextArea();
            this.m_descriptionTextArea.setLineWrap(true);
            this.m_descriptionTextArea.setWrapStyleWord(true);
            this.m_descriptionTextArea.setRows(5);
            panel.add((Component)new JScrollPane(this.m_descriptionTextArea), "Center");
            VWAccessibilityHelper.setAccessibility(this.m_descriptionTextArea, this, VWResource.OperationDescription, VWResource.OperationDescription);
            JLabel label = new JLabel(VWResource.OperationDescription);
            VWAccessibilityHelper.setAccessibility(label, this, VWResource.OperationDescription, VWResource.OperationDescription);
            VWAccessibilityHelper.setLabelFor(label, this.m_descriptionTextArea);
            return panel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel createParametersPanel() {
        JPanel panel = null;
        TableColumn tcElement = null;
        try {
            this.m_parametersToolBar = new VWToolbarBorder(VWResource.Parameters, 0x10000000);
            this.m_parametersToolBar.addToolbarBorderActionNotifier(this);
            panel = this.m_parametersToolBar.getClientPanel();
            panel.setLayout(new BorderLayout());
            this.m_parameterTableModel = new VWConfigParameterTableModel(this.m_parent);
            this.m_parameterTableModel.addTableModelListener(this);
            this.m_parameterTable = new VWTable(this.m_parameterTableModel);
            this.m_parameterTable.setRowSelectionAllowed(true);
            this.m_parameterTable.getSelectionModel().addListSelectionListener(this);
            this.m_parameterTable.getSelectionModel().setSelectionMode(0);
            this.m_parameterTable.setDefaultRenderer(String.class, new VWTableCellRenderer());
            this.m_parameterTable.setDefaultEditor(String.class, new VWTableCellEditor(new JTextField()));
            panel.add((Component)new JScrollPane(this.m_parameterTable), "Center");
            VWAccessibilityHelper.setAccessibility(this.m_parameterTable, this, VWResource.ParametersTable, VWResource.ParametersTable);
            JLabel label = new JLabel(VWResource.ParametersTable);
            VWAccessibilityHelper.setAccessibility(label, this, VWResource.ParametersTable, VWResource.ParametersTable);
            VWAccessibilityHelper.setLabelFor(label, this.m_parameterTable);
            tcElement = this.m_parameterTable.getColumnModel().getColumn(1);
            if (tcElement != null) {
                tcElement.setCellEditor(new DefaultCellEditor(this.m_parameterTableModel.getParameterTypeComboBox()));
            }
            if ((tcElement = this.m_parameterTable.getColumnModel().getColumn(2)) != null) {
                tcElement.setCellEditor(new DefaultCellEditor(this.m_parameterTableModel.getParameterModeComboBox()));
            }
            return this.m_parametersToolBar;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private void updateTableSelection(JTable table, int nRow) {
        if (table == null) {
            return;
        }
        if (nRow == table.getSelectedRow()) {
            table.clearSelection();
        }
        if (nRow <= table.getRowCount() - 1) {
            table.setRowSelectionInterval(nRow, nRow);
        } else if (table.equals(this.m_parameterTable)) {
            this.onSelectedParameter();
        }
    }

    private void onSelectedOperation() {
        int nRowIndex = -1;
        String name = null;
        int nButtons = 0;
        try {
            nRowIndex = this.m_operationTable.getSelectedRow();
            name = (String)this.m_operationTableModel.getValueAt(nRowIndex, 0);
            if (name == null || name.length() == 0) {
                nButtons = 0x10000040;
                this.m_operationsToolBar.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_operationsToolBar.getClientPanel(), 2, nButtons));
            } else {
                nButtons = 0x10000040;
                this.m_operationsToolBar.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_operationsToolBar.getClientPanel(), 1, nButtons));
            }
            this.m_descriptionTextArea.getDocument().removeDocumentListener(this);
            this.m_descriptionTextArea.setText((String)this.m_operationTableModel.getValueAt(nRowIndex, 1));
            this.m_descriptionTextArea.getDocument().addDocumentListener(this);
            this.m_parameterTable.stopEditing();
            this.m_parameterTableModel.refresh(this.m_operationTableModel.getRowItemAt(nRowIndex));
            this.updateTableSelection(this.m_parameterTable, 0);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onSelectedParameter() {
        int nRowIndex = -1;
        String name = null;
        int nButtons = 0;
        try {
            nRowIndex = this.m_parameterTable.getSelectedRow();
            name = (String)this.m_parameterTableModel.getValueAt(nRowIndex, 0);
            if (name == null || name.length() == 0) {
                nButtons = 0x10000000;
                this.m_parametersToolBar.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_parametersToolBar.getClientPanel(), 2, nButtons));
            } else {
                nButtons = 0x10000000;
                this.m_parametersToolBar.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_parametersToolBar.getClientPanel(), 1, nButtons));
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onUpdateDescription() {
        try {
            if (this.m_operationTableModel != null && this.m_operationTable != null) {
                int nRowIndex = this.m_operationTable.getSelectedRow();
                String currentDesc = this.m_descriptionTextArea.getText();
                this.m_operationTableModel.setValueAt(currentDesc, nRowIndex, 1);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

